/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome.variant;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lotr.common.LOTRDimension;
import lotr.common.network.LOTRPacketBiomeVariantsUnwatch;
import lotr.common.network.LOTRPacketBiomeVariantsWatch;
import lotr.common.network.LOTRPacketHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class LOTRBiomeVariantStorage {
    private static Map<LOTRDimension, Map<ChunkCoordIntPair, byte[]>> chunkVariantMap = new HashMap<LOTRDimension, Map<ChunkCoordIntPair, byte[]>>();
    private static Map<LOTRDimension, Map<ChunkCoordIntPair, byte[]>> chunkVariantMapClient = new HashMap<LOTRDimension, Map<ChunkCoordIntPair, byte[]>>();

    private static Map<ChunkCoordIntPair, byte[]> getDimensionChunkMap(World world) {
        LOTRDimension dim;
        Map<LOTRDimension, Map<ChunkCoordIntPair, byte[]>> sourcemap = !world.field_72995_K ? chunkVariantMap : chunkVariantMapClient;
        Map<ChunkCoordIntPair, byte[]> map = sourcemap.get((Object)(dim = LOTRDimension.getCurrentDimensionWithFallback(world)));
        if (map == null) {
            map = new HashMap<ChunkCoordIntPair, byte[]>();
            sourcemap.put(dim, map);
        }
        return map;
    }

    private static ChunkCoordIntPair getChunkKey(Chunk chunk) {
        return new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h);
    }

    public static byte[] getChunkBiomeVariants(World world, Chunk chunk) {
        return LOTRBiomeVariantStorage.getChunkBiomeVariants(world, LOTRBiomeVariantStorage.getChunkKey(chunk));
    }

    public static byte[] getChunkBiomeVariants(World world, ChunkCoordIntPair chunk) {
        return LOTRBiomeVariantStorage.getDimensionChunkMap(world).get(chunk);
    }

    public static void setChunkBiomeVariants(World world, Chunk chunk, byte[] variants) {
        LOTRBiomeVariantStorage.setChunkBiomeVariants(world, LOTRBiomeVariantStorage.getChunkKey(chunk), variants);
    }

    public static void setChunkBiomeVariants(World world, ChunkCoordIntPair chunk, byte[] variants) {
        LOTRBiomeVariantStorage.getDimensionChunkMap(world).put(chunk, variants);
    }

    public static void clearChunkBiomeVariants(World world, Chunk chunk) {
        LOTRBiomeVariantStorage.clearChunkBiomeVariants(world, LOTRBiomeVariantStorage.getChunkKey(chunk));
    }

    public static void clearChunkBiomeVariants(World world, ChunkCoordIntPair chunk) {
        LOTRBiomeVariantStorage.getDimensionChunkMap(world).remove(chunk);
    }

    public static void loadChunkVariants(World world, Chunk chunk, NBTTagCompound data) {
        if (LOTRBiomeVariantStorage.getChunkBiomeVariants(world, chunk) == null) {
            byte[] variants = data.func_74764_b("LOTRBiomeVariants") ? data.func_74770_j("LOTRBiomeVariants") : new byte[256];
            LOTRBiomeVariantStorage.setChunkBiomeVariants(world, chunk, variants);
        }
    }

    public static void saveChunkVariants(World world, Chunk chunk, NBTTagCompound data) {
        byte[] variants = LOTRBiomeVariantStorage.getChunkBiomeVariants(world, chunk);
        if (variants != null) {
            data.func_74773_a("LOTRBiomeVariants", variants);
        }
    }

    public static void clearAllVariants(World world) {
        LOTRBiomeVariantStorage.getDimensionChunkMap(world).clear();
        FMLLog.info((String)"Unloading LOTR biome variants in %s", (Object[])new Object[]{LOTRDimension.getCurrentDimensionWithFallback((World)world).dimensionName});
    }

    public static void performCleanup(WorldServer world) {
        Map<ChunkCoordIntPair, byte[]> dimensionMap = LOTRBiomeVariantStorage.getDimensionChunkMap((World)world);
        dimensionMap.size();
        System.nanoTime();
        ArrayList<ChunkCoordIntPair> removalChunks = new ArrayList<ChunkCoordIntPair>();
        for (ChunkCoordIntPair chunk : dimensionMap.keySet()) {
            if (world.field_73059_b.func_73149_a(chunk.field_77276_a, chunk.field_77275_b)) continue;
            removalChunks.add(chunk);
        }
        for (ChunkCoordIntPair chunk : removalChunks) {
            dimensionMap.remove(chunk);
        }
    }

    public static void sendChunkVariantsToPlayer(World world, Chunk chunk, EntityPlayerMP entityplayer) {
        byte[] variants = LOTRBiomeVariantStorage.getChunkBiomeVariants(world, chunk);
        if (variants != null) {
            LOTRPacketBiomeVariantsWatch packet = new LOTRPacketBiomeVariantsWatch(chunk.field_76635_g, chunk.field_76647_h, variants);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
        } else {
            String dimName = world.field_73011_w.func_80007_l();
            int posX = chunk.field_76635_g << 4;
            int posZ = chunk.field_76647_h << 4;
            String playerName = entityplayer.func_70005_c_();
            FMLLog.severe((String)"Could not find LOTR biome variants for %s chunk at %d, %d; requested by %s", (Object[])new Object[]{dimName, posX, posZ, playerName});
        }
    }

    public static void sendUnwatchToPlayer(World world, Chunk chunk, EntityPlayerMP entityplayer) {
        LOTRPacketBiomeVariantsUnwatch packet = new LOTRPacketBiomeVariantsUnwatch(chunk.field_76635_g, chunk.field_76647_h);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
    }

    public static int getSize(World world) {
        Map<ChunkCoordIntPair, byte[]> map = LOTRBiomeVariantStorage.getDimensionChunkMap(world);
        return map.size();
    }
}

